﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.IWS.MappingService.Helpers;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService.Mappers
{
    public class MapOtherNameToCrm : MapperRelatedBase
    {
        public MapOtherNameToCrm(IPpmsContextHelper ppmsContextHelper, IPpmsHelper ppmsHelper)
            : base(ppmsContextHelper, ppmsHelper)
        {}

        public async Task<ppms_othername> MapInsert(ProviderOtherName otherName, Account provider)
        {
            // map entity
            var entity = new ppms_othername
            {
                Id = Guid.NewGuid(),
                ppms_name = otherName.Name,
                ppms_othercredential = otherName.OtherCredential
            };

            if (otherName.OtherNameTypeSpecified) entity.ppms_othernametype = EnumHelper.MapEnumToOptionSetValue<ppms_othername_ppms_othernametype>(otherName.OtherNameType.ToString());

            await Task.Run(() => {});

            return entity;
        }

        public async Task<ppms_othername> MapUpdate(ProviderOtherName entity, Account provider)
        {
            // get entity
            var crmEntity = GetCrmEntity(provider, entity.Name);

            // matching account not found
            if (crmEntity == null) return await MapInsert(entity, provider);

            var newEntity = new ppms_othername()
            {
                Id = crmEntity.Id,
                ppms_name = crmEntity.ppms_name,
                ppms_othercredential = crmEntity.ppms_othercredential,
                ppms_othernametype = crmEntity.ppms_othernametype
            };

            // Map fields
            if (IsChanged(entity.OtherCredential, newEntity.ppms_othercredential)) newEntity.ppms_othercredential = entity.OtherCredential;

            if (entity.OtherNameTypeSpecified) newEntity.ppms_othernametype = EnumHelper.MapEnumToOptionSetValue<ppms_othername_ppms_othernametype>(entity.OtherNameType.ToString());

            return newEntity;
        }

        private static ppms_othername GetCrmEntity(Account provider, string id)
        {
            var list = provider.ppms_account_ppms_othername;
            if (list == null) return null;

            var ppmsOthernames = list as ppms_othername[] ?? list.ToArray();

            return ppmsOthernames.Any() ? ppmsOthernames.FirstOrDefault(x => x.ppms_name == id) : null;
        }

        private static ProviderOtherName ConvertEntity<T>(T entity)
        {
            return (ProviderOtherName)Convert.ChangeType(entity, typeof(ProviderOtherName));
        }

        public override async Task<Entity> MapUpdate<T>(T entity, Entity parent)
        {
            return await MapUpdate(ConvertEntity(entity), (Account)parent);
        }

        public override async Task<Entity> MapInsert<T>(T entity, Entity parent)
        {
            return await MapInsert(ConvertEntity(entity), (Account)parent);
        }

        public override void AddChildrenToProvider(IList<Entity> entities, Entity parent)
        {
            if (IsWithinContext) AssociateRelatedEntities(parent, entities, "ppms_account_ppms_othername");
            else
            {
                if (entities != null && entities.Count > 0)
                {
                    var account = (Account)parent;
                    if (account != null) account.ppms_account_ppms_othername = ConvertEntityList<ppms_othername>(entities);
                }
            }
        }

        public override IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent)
        {
            if (entities == null || !entities.Any()) return null;

            // Check provider
            var provider = (Account)parent;
            if (provider == null) return null;

            var list = new List<T>();

            // Map schema entities for delete
            foreach (var item in entities)
            {
                var entity = ConvertEntity(item);
                var entity1 = entity;
                var matches = provider.ppms_account_ppms_othername.Where(p => p.ppms_name == entity1.Name);
                list.AddRange((IEnumerable<T>)matches);
            }

            return EntityDelete((IEnumerable<ppms_othername>)list);
        }
    }
}